//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Collections;

namespace Testing
{
	// Deklaracja zbioru:
	public class CSharpCollection 
	{
		int[] items;

		public CSharpCollection() 
		{
			items = new int[5] {1, 2, 3, 4, 5};
		}

		public CSharpEnumerator GetEnumerator() 
		{
			return new CSharpEnumerator(this);
		}

		// Deklaracja klasy enumeratora:
		public class CSharpEnumerator 
		{
			int nIndex;
			CSharpCollection collection;
			public CSharpEnumerator(CSharpCollection coll) 
			{
				collection = coll;
				nIndex = -1;
			}

			public bool MoveNext() 
			{
				nIndex++;
				return(nIndex < collection.items.GetLength(0));
			}

			public int Current 
			{
				get 
				{
					return(collection.items[nIndex]);
				}
			}
		}
	}

	public class GenericCollection: IEnumerable 
	{
		int[] items;
		public GenericCollection() 
		{
			items = new int[5] {6, 7, 8, 9, 10};
		}

		public GenericEnumerator GetEnumerator() 
		{
			return new GenericEnumerator(this);
		}

		// Implementacja metody GetEnumerator():
		IEnumerator IEnumerable.GetEnumerator() 
		{
			return GetEnumerator();
		}

		// Deklaracja enumeratora i implementacja interfejsu IEnumerator:
		public class GenericEnumerator: IEnumerator 
		{
			int nIndex;
			GenericCollection collection;
			public GenericEnumerator(GenericCollection coll) 
			{
				collection = coll;
				nIndex = -1;
			}

			public void Reset() 
			{
				nIndex = -1;
			}

			public bool MoveNext() 
			{
				nIndex++;
				return(nIndex < collection.items.GetLength(0));
			}

			public int Current 
			{
				get 
				{
					return(collection.items[nIndex]);
				}
			}

			// Bieca waciwo interfejsu IEnumerator:
			object IEnumerator.Current 
			{
				get 
				{
					return(Current);
				}
			}
		}
	}

	class ForeachMain
	{
		static void Main(string[] args)
		{
			string [] sa = new string [] { "To", "jest", "test" };
			foreach(string s in sa)
			{
				Console.WriteLine(s);
			}
			CSharpCollection cscol = new CSharpCollection();
			Console.WriteLine("Wartoci w zbiorze C# to:");
			foreach (int i in cscol) 
			{
				Console.WriteLine(i);
			}
			GenericCollection gencol = new GenericCollection();
			Console.WriteLine("Wartoci w oglnym zbiorze to:");
			foreach (int i in gencol) 
			{
				Console.WriteLine(i);
			}
		}
	}
}
